function Set-AdminUser	{  
	<# 
	.SYNOPSIS
			Clears adminCount, and enables inherited security on a user account.
	
	.DESCRIPTION
			Clears adminCount, and enables inherited security on a user account.
	
	.NOTES
	    Version    	      	: v1.0
	    Wish list						: 
	    Rights Required			: UserAdministrator
	    Sched Task Req'd		: No
	    Lync Version				: N/A
	    Lync Version				: N/A
	    Author       				: Pat Richard, Exchange MVP
	    Email/Blog/Twitter	: pat@innervation.com 	http://www.ehloworld.com @patrichard
	    Dedicated Post			: http://www.ehloworld.com/1621
	    Disclaimer   				: You running this script means you won't blame me if this breaks your stuff.
	    Info Stolen from 		: http://serverfault.com/questions/304627/powershell-script-to-find-ad-users-with-admincount-0
													: http://morgansimonsen.wordpress.com/2012/01/26/adminsdholder-protected-groups-sdprop-and-moving-mailboxes-in-exchange/
	
	.LINK     
	    http://www.ehloworld.com/1621
	
	.INPUTS
			You can pipeline input to this command		
			
	.PARAMETER UserName
			Create the scheduled task to run the script daily. It does NOT create the required Exchange receive connector.
	
	.EXAMPLE 
			Set-AdminUser -UserName [user name]
			
			Description
			-----------
			Clears the adminCount of the specified user, and enabled inherited security
	
	.EXAMPLE 
			Get-AdGroupMember [group name] | Set-AdminUser
			
			Description
			-----------
			Clears the adminCount of all group members, and enabled inherited security
	
	#>
	#Requires -Version 2.0	
	
	[CmdletBinding(SupportsShouldProcess = $True)]
	param (
		[Parameter(ValueFromPipeline = $true, ValueFromPipelineByPropertyName = $True, Mandatory = $False)]
	  [ValidateNotNullOrEmpty()]
		[string]$UserName
	)
	Begin{
		## allows inheritance 
		[bool]$isProtected = $false
		## preserves inherited rules 
		[bool]$PreserveInheritance = $true
	}
	Process{
		[string]$dn = (Get-ADUser $UserName).DistinguishedName
		Set-AdObject -identity $dn -clear adminCount
		$user = [ADSI]"LDAP://$dn"
		$acl = $user.objectSecurity
		Write-Verbose $dn
		Write-Verbose "Original permissions blocked:"
		Write-Verbose $acl.AreAccessRulesProtected
		if ($acl.AreAccessRulesProtected){
			$acl.SetAccessRuleProtection($isProtected,$PreserveInheritance)
			$inherited = $acl.AreAccessRulesProtected
			$user.commitchanges()
			Write-Verbose "Updated permissions blocked:"
			Write-Verbose $acl.AreAccessRulesProtected
		}
	}
	End{
		remove-variable acl
		remove-variable UserName
		remove-variable isProtected
		remove-variable PreserveInheritance
		remove-variable dn
		remove-variable user
	}
} # end function Set-AdminUser

