'********************************************************************
'*
'* File:           ResetAccountsAdminSDHolder.vbs 
'* Created:        November 2003
'* Version:        1.0
'*
'*  Main Function:  Resets all accounts that have adminCount = 1 back
'*	to 0 and enables the inheritance flag
'*
'*  ResetAccountsAdminSDHolder.vbs 
'*
'* Copyright (C) 2003 Microsoft Corporation
'*
'********************************************************************
' Source 817433 Delegated permissions are not available and inheritance is automatically disabled

Const SE_DACL_PROTECTED = 4096

On Error Resume Next

Dim sDomain
Dim sADsPath
Dim sPDC


Dim oCon 
Dim oCmd
Dim oRst
Set oRst = CreateObject("ADODB.Recordset")
Set oCmd = CreateObject("ADODB.Command")
Set oCon = CreateObject("ADODB.Connection")

Dim oRoot
Dim oDomain
Dim oADInfo
Dim oInfo
Set oADInfo = CreateObject("ADSystemInfo")
Set oInfo = CreateObject("WinNTSystemInfo")
sPDC = oInfo.PDC & "." & oADInfo.DomainDNSName

oCon.Provider = "ADSDSOObject"
oCon.Open "Active Directory Provider"

oCmd.ActiveConnection = oCon

Set oRoot = GetObject("LDAP://rootDSE")
sDomain = oRoot.Get("defaultNamingContext")
Set oDomain = GetObject("LDAP://" & sDomain)
sADsPath = "<" & oDomain.ADsPath & ">"

oCmd.CommandText = "SELECT ADsPath FROM 'LDAP://" & sPDC & "/" & sDomain & "' WHERE objectCategory='person' and objectClass = 'User' AND adminCount = 1"
Set oRst = oCmd.Execute

WScript.Echo "searching fr objects with 'admin count = 1' in " & sDomain

If oRst.RecordCount = 0 Then
    WScript.Echo "no accounts found"
    WScript.Quit
End If

Do While Not oRst.EOF
    WScript.Echo  "found object " & oRst.Fields("ADsPath")
    If SetInheritanceFlag(oRst.Fields("ADsPath")) = 0 Then WScript.Echo "Inheritance flag set"
    If SetAdminCount(oRst.Fields("ADsPath"), 0) = 0 Then WScript.Echo "adminCount set to 0"
    WScript.Echo  "=========================================="
    oRst.MoveNext
Loop


Private Function SetInheritanceFlag(DSObjectPath)

    Dim oSD
    Dim oDACL
    Dim lFlag
    Dim oIADs

    Set oIADs = GetObject(DSObjectPath)

    Set oSD = oIADs.Get("nTSecurityDescriptor")

    If oSD.Control And SE_DACL_PROTECTED Then
        oSD.Control = oSD.Control - SE_DACL_PROTECTED
    End If

    oIADs.Put "nTSecurityDescriptor", oSD
    oIADs.SetInfo
    
    If Err.Number <> 0 Then
        SetInheritanceFlag = Err.Number
    Else
        SetInheritanceFlag = 0
    End If

End Function


Private Function SetAdminCount(DSObjectPath, AdminCount)

    Dim oIADs
    Dim iAdminCount

    Set oIADs = GetObject(DSObjectPath)

    iAdminCount = oIADs.Get("adminCount")

    If iAdminCount = 1 Then iAdminCount = 0

    oIADs.Put "adminCount", iAdminCount
    oIADs.SetInfo
    If Err.Number <> 0 Then
        SetAdminCount = Err.Number
    Else
        SetAdminCount = 0
    End If
    
End Function
